////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBFileOpenDialog.h
//		Definition of the parent class that allows an Open Dialog through the respective platform's Dialog or Panel.
//
//  Copyright © 2012 Acclivity Group LLC. All rights reserved.
//
//  Change History (most recent first):
//
//  03/01/12  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"

namespace ObsoleteBridge
{
	class EXTERNAL_API OBFileDialog
	{
	public:
		virtual void SetMessage(const CPString& TextToDisplay) = 0;
		virtual void SetNameField(const CPString& Name) = 0;
		virtual void SetDefaultDirectoryPath(const CPString& DefaultDirectoryPath) = 0;
		virtual void SetHideExtension(bool ShouldExtensionBeHidden) = 0;
		virtual void SetAllowedFileType(const CPString& AllowedFileType) = 0;
		virtual void SetAllowedFileTypes(const CPArray& AllowedFileTypes) = 0;
		virtual void SetAllowsOtherFileTypes(bool AllowsOtherFileTypes) = 0;

	protected:
		OBFileDialog(void) {};
		virtual ~OBFileDialog(void) {};
	};
}
